//+------------------------------------------------------------------+
//|                                                     Yoni Yum.mq4 |
//|                         Copyright  2007, Sylvan Arinaya Gilbert |
//|             Creative Commons Attribution-Share Alike 3.0 License |
//|                   http://creativecommons.org/licenses/by-sa/3.0/ |
//|                                                                  |
//| Yoni Yum is a hybrid of the Schaff Trend Cycle (an MACD filtered |
//| through a stochastic oscillator) and Ehlers' Fisher Transform    |
//| (a stochastic modulated using the Fisher Transformation).  The   |
//| end result is similar to a stochastic oscillator, but with       |
//| significantly less signal noise.                                 |
//|                                                                  |
//| Version 1.0 - 2007/5/2                                           |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "The Countess" // For all you Tom Robbins fans.

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 DarkKhaki
#property indicator_color2 Brown
#property indicator_level1 0
//---- input parameters
extern int       fast=9;  // Fast EMA period
extern int       slow=12; // Slow EMA period
extern int       cycle=6; // Stochastic period
//---- buffers
double macdBuffer[];
double fishBuffer[];
double yoniBuffer[];
double echoBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   IndicatorBuffers(4);
   SetIndexBuffer(2, macdBuffer);
   SetIndexBuffer(3, fishBuffer);
   
   SetIndexStyle(1, DRAW_LINE);
   SetIndexBuffer(1, yoniBuffer);
   SetIndexStyle(0, DRAW_LINE);
   SetIndexBuffer(0, echoBuffer);
   
   IndicatorShortName("Yoni Yum ("+fast+","+slow+","+cycle+") ");
   SetIndexLabel(1, "Signal");
   SetIndexLabel(0, "Echo");
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int limit,i,k;
   double hi,lo,val,prev;
   
   limit = Bars - slow;
   prev = 0;
   
   // MACD
   for (i = limit; i >= 0; i--)
   {
      macdBuffer[i] = iMA(NULL, 0, fast, 0, MODE_EMA, PRICE_TYPICAL, i) - 
                      iMA(NULL, 0, slow, 0, MODE_EMA, PRICE_TYPICAL, i);
   }
   
   // Stochastic / Fisher Transformation
   for (i = limit; i >= 0; i--)
   {
      // Find the high and low MACD value in the previous cycle
      hi = -1000000;
      lo = 1000000;
      for (k = 0; k < cycle; k++)
      {
         if (macdBuffer[i + k] > hi) hi = macdBuffer[i + k];
         if (macdBuffer[i + k] < lo) lo = macdBuffer[i + k];
      }
      val = ((macdBuffer[i] - lo) / (hi - lo)) - 0.5;
      
      // This is Ehlers' Fisher Transform
      val = MathMin(MathMax((val + prev) * 2/3, -0.9999), 0.9999);
      fishBuffer[i] = MathLog((1+val)/(1-val));
      
      prev = val;
   }
   
   // Smooth the result with a 2 period EMA, and plot a second line offset by one point
   for (i = limit; i >= 0; i--)
   {
      yoniBuffer[i] = iMAOnArray(fishBuffer, Bars, 2, 0, MODE_EMA, i);
      echoBuffer[i] = yoniBuffer[i + 1];
   }
   
   return(0);
}